<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.sec.gov/edgar/ta/tawfiler"	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes">
	<xsl:template name="Item4">
		<h3>
			Document Retention Information
		</h3>
		<xsl:call-template name="documentRetentionInfo" />
	</xsl:template>

	<xsl:template  name="documentRetentionInfo">
		
		<table role="presentation" >
			<tr>
				<b>10.</b> For each issue for which registrant acted as transfer agent and
				 for any issues for which registrant assumed transfer agent functions since the last amendment to Form TA-1, furnish:
			</tr>
				<tr>
					<td class="label"><b>10(a).</b> Is there a successor transfer agent?</td>
					<td>							
						<xsl:choose>
							<xsl:when test="p:formData/p:documentRetention/p:successorTransferAgents = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes
						<xsl:choose>
							<xsl:when test="p:formData/p:documentRetention/p:successorTransferAgents = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No							
					</td>
				</tr>	
			<xsl:if test="p:formData/p:documentRetention/p:successorTransferAgents = 'Y'">		
				<xsl:for-each select="p:formData/p:documentRetention/p:tawSuccessorDetails">		
					<tr>
						<td class="label">	
								<b>10(b).</b> Name of successor transfer agents:						
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<b>10(c).</b> Address:
						</td>
					</tr>			
					<tr>
						<td class="label">
							<blockquote>
								10(c)(i). Address 1 
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:tawSuccessorAddress/ns1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								10(c)(ii). Address 2 
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:tawSuccessorAddress/ns1:street2"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								10(c)(iii). City
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:tawSuccessorAddress/ns1:city"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								10(c)(iv). State or Country
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
									select="string(./p:tawSuccessorAddress/ns1:stateOrCountry)" />
							</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								10(c)(v). Postal Code
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:tawSuccessorAddress/ns1:zipCode"/>
							</div>
						</td>
					</tr>
				<tr>
					<td class="label"><b>10(d).</b> Is the successor transfer agent registered as a transfer agent pursuant to the Act?</td>
					<td>							
						<xsl:choose>
							<xsl:when test="p:successorRegistered = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes
						<xsl:choose>
							<xsl:when test="p:successorRegistered = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No							
					</td>
				</tr>							
					<tr><td></td></tr>													
				</xsl:for-each>
			</xsl:if>		
		</table>

		<table role="presentation" >
			<tr>
				<b>11.</b> For each issue for which registrant acted as transfer agent and 
				for any issues for which registrant assumed transfer agent functions since the 
				last amendment to Form TA-1, furnish: name(s) and address(es) of the person(s) 
				who has or will have custody or possession of the books and records which the 
				registrant maintained in connection with its performance of transfer agent functions.
			</tr>
				<xsl:for-each select="p:formData/p:documentRetention/p:tawCustodians">		
					<tr>
						<td class="label">	
							<b>11(a).</b> Name of Custodian: 						
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<b>11(b).</b> Address:
						</td>
					</tr>			
					<tr>
						<td class="label">
							<blockquote>
								11(b)(i). Address 1
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:tawCustodianAddress/ns1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								11(b)(ii). Address 2 
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:tawCustodianAddress/ns1:street2"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								11(b)(iii). City
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:tawCustodianAddress/ns1:city"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								11(b)(iv). State or Country
							</blockquote>
						</td>
						<td>						
						<div class="fakeBox3">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
									select="p:tawCustodianAddress/ns1:stateOrCountry" />
							</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
						</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								11(b)(v). Postal Code
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:tawCustodianAddress/ns1:zipCode"/>
							</div>
						</td>
					</tr>						
					<tr><td></td></tr>													
				</xsl:for-each>	
		</table>

		<table role="presentation" >
			<tr>
				<b>12.</b> Furnish the name(s) and address(es), if different from Item 11, where such books and records will be located.
			</tr>
				<xsl:for-each select="p:formData/p:documentRetention/p:tawLocations">		
					<tr>
						<td class="label">	
							<b>12(a).</b> Name of Custodian: 						
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<b>12(b).</b> Address:
						</td>
					</tr>			
					<tr>
						<td class="label">
							<blockquote>
								12(b)(i). Address 1
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:tawLocationAddress/ns1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								12(b)(ii). Address 2
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:tawLocationAddress/ns1:street2"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								12(b)(iii). City
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:tawLocationAddress/ns1:city"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								12(b)(iv). State or Country
							</blockquote>
						</td>
						<td>	
							<div
								class="fakeBox3">
								<xsl:call-template
									name="stateDescription">
									<xsl:with-param
										name="stateCode"
										select="p:tawLocationAddress/ns1:stateOrCountry" />
								</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>						
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								12(b)(v). Postal Code
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:tawLocationAddress/ns1:zipCode"/>
							</div>
						</td>
					</tr>						
					<tr><td></td></tr>													
				</xsl:for-each>	
		</table>	
		
	</xsl:template>
</xsl:stylesheet>